require( "scripts/style.lua" );
DebugOut("ChoosePlayer");

function ShowSubmitOptions( show )
	EnableWindow( "delete", show )
	EnableWindow( "chooseok", show )
	EnableWindow( "editname", show )
end

function ShowCreateOptions( show )
	EnableWindow( "newplayer", show )
end

function UpdatePlayerChoices( curUser, numUsers, userTable )

	if (numUsers >= kMaxUsers) then
		ShowCreateOptions(false)
	else
		ShowCreateOptions(true)
	end

	if (numUsers==0) then
		ShowSubmitOptions( false )
	else
		ShowSubmitOptions( true )
	end

	for i = 0,numUsers-1 do
		SetLabel( "button"..i, userTable[ i+1 ] );
		EnableWindow( "button"..i, true ) ;
	end

	for i = numUsers, kMaxUsers do
		EnableWindow( "button"..i, false ) ;
	end

	if numUsers>0 then
		SetButtonToggleState( "button"..curUser, true );
	end

	DebugOut("UpdatePlayerChoices");
end

NameFont = {
  standardFont,
  17,
  BlackColor
};

HeaderFont = {
  standardFont,
  30,
  BlackColor
};

ButtonSpacingX = 60;
ButtonX = kCenter;
ButtonY = 90;
ButtonYSpace = 35;

kMaxUsers = 8

NameButtonGraphics = {
	"buttons/choosenameup",
	"buttons/choosenamedown",
	"buttons/choosenameover",
	"buttons/choosenamedown"
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};

--gSelected = -1 ;

function AddButtons( N )

	t = { SetStyle(NameStyle), BeginGroup() };

	for i = 0,N-1 do
		table.insert(t,
			Button{
				name="button"..i,
--				command=function() gSelected = i; end,
				label="#name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*i),
			}
		);	
	end

	return Group(t);
end

DLGSPEC = 
{
	image = "backgrounds/largedialog",
	mask = exists("backgrounds/largedialog.mask.png"),
	x=kCenter+5,
	y=kCenter-5,
	
	TChoosePlayer
	{
		x = 0, y = 0, w=kMax, h=kMax,
		
		Text
		{
			font = HeaderFont,
			name = "selectaplayer",
			x=0,y=50,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "selectaplayer"
		};
		
		AddButtons( kMaxUsers );
		
		SetStyle(ThinButtonStyle);
			
		Button
		{
			x=kCenter-ButtonSpacingX,
			y=375,
			name="editname",
			label="",
			type = kPush,
			label="editname",
			command = function()
				gEnterNameValue = GetSelectedPlayerName();
				name = DoModal("scripts/entername.lua");
				if (not(name == nil)) then
					SetCurrentUser(GetCurrentSelectedUser());
					ChangeCurrentUserName(name);
					SetPlayerChoices();
					SetWelcomeName();
				end
			end
		};

		Button
		{
			x=kCenter+ButtonSpacingX,
			y=405,
			name="chooseok",
			label="ok",
			type = kPush,
			default = true,
			command = function()
				SetCurrentUser(GetCurrentSelectedUser());
				SetWelcomeName();
				StartClose(); -- PopModal("chooseplayer");
			end
		};
			
		Button
		{
			x=kCenter+ButtonSpacingX,
			y=375,
			name="newplayer",
			label="newplayer",
			type = kPush,
			command =
				function()
					gEnterNameValue = "";
					name = DoModal("scripts/entername.lua");
					if (not(name == nil)) then
						CreateNewUser(name);
						SetPlayerChoices()
					end
				end
		};
			
		Button
		{
			x=kCenter-ButtonSpacingX,
			y=405,
			name="delete",
			label="deleteplayer",
			type = kPush,
			command = function()
				result = dfDisplayDialog 
				{ 
					"scripts/yesno.lua", 
					body = "deleteconfirm",
					title = "deletetitle" 
				};
				if (result == 'yes') then
					DeleteUser(GetCurrentSelectedUser())
					SetPlayerChoices()
				end
			end
		};
	}
};

MakeDialog
{
	-- Name the modal dialog
	name = "chooseplayer",
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(DLGSPEC),
	}
};

